﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl" %>
<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/jquery-1.3.2.min.js")); %>
<div id="shortenUrlToolbox" class="off itineraryAddinBox">
    <h3>Short URL</h3>
    <% if(Ajax.JavaScriptEnabled()) { %><span class="close" onclick="$('#shortenUrlToolbox').fadeOut()">Close</span><% }    %>
    <div style="min-height:70px">
        <p>
            <input type="text" style="width:80%" />
        </p>
    </div>
</div>
<%
Ajax.RegisterClientScriptBlock(
    @"function generateShortenUrl(serviceCall) {
            $('#shortenUrlToolbox').fadeIn();
            $('#shortenUrlToolbox div').addClass('loading');
            $.ajax({
                url: serviceCall,
                method: 'GET',
                dataType: 'text',
                beforeSend: function(xhr) { xhr.setRequestHeader('Content-Type', 'application/json'); },
                success: function(json) {
                    var url = json.substring(1, json.length - 1);
                    $('#shortenUrlToolbox div').removeClass('loading');
                    $('#shortenUrlToolbox input').val(url);
                    $('#shortenUrlToolbox input').focus().select();
                }
            });
        }");
%>